/*
 * Parser.java
 *
 * 
 */
 
package DisCSP.CSPLexerParser;

import DisCSP.Exception.*;
import DisCSP.CSP.Constraint.*;
import DisCSP.DistributedCSP.ExternalConstraint.*;
import DisCSP.CSP.*;
import DisCSP.DistributedCSP.*;


/**
 * @ version 1.0
 *
 * @ author Nocerino Francesca
 *
 * @ since JDK 1.4
 *
 */

public class Parser
{
	Lexer lexer;
 	String current;
 
 	/** Costruttore di Parser
     * 
     * @param s il lexer da cui Parser ricever i token correnti in input
     * 
     */
     
	public Parser(Lexer s)
	{
		lexer=s;
	}
	
	
	/**Controlla la sintassi di un constraint problem
     * 
     * @return un ConstraintProblem
     *
     */
     
	public ConstraintProblem parseConstraintProblem() throws 	ParserException,
																LexerException,
																ExistentVarException,
																UnknownVariableException,
																NotBinaryConstrException
	{
		ConstraintProblem constrProbl= new ConstraintProblem();
		
		String txt=lexer.getString();
		if(! txt.equals(Symbols.VARIABLES)) throw new ParserException("not found the expected keyword "+Symbols.VARIABLES);
		char c;
		
		//separ
		String var=lexer.getString();
		
		while(!var.equals(Symbols.CONSTRAINTS))
		{
			c=lexer.getChar(); //consuma:	
			if(c!=Symbols.DUE_PUNTI) throw new ParserException("expected "+Symbols.DUE_PUNTI+" found "+c);
			c=lexer.getChar(); //consuma:
			if(c!=Symbols.DUE_PUNTI) throw new ParserException("expected "+Symbols.DUE_PUNTI+" found "+c);
			constrProbl.addVariable( new Variable(var, parseDomain() ));
			
			//separ
			
			var=lexer.getString();
		}

		//separ
		String first;
		try
		{
			first=lexer.getString();
		}
		catch(LexerException e)
		{
			return constrProbl;		
		}

		String second;
		char op;
		boolean spec;
		while(true)
		{
			spec=false;
			op=lexer.getChar();
			if(op==Symbols.SPECIAL)
			{
				op=lexer.getChar();
				spec=true;
			}
			
			
			if(op=='='&& !spec)
			{
				second=lexer.getString();
				constrProbl.addConstraint(new EqualConstraint(constrProbl.getVarByName(first),constrProbl.getVarByName(second)));
			}
			else if(op=='='&& spec)
			{
				second=lexer.getString();
				constrProbl.addConstraint(new NotEqualConstraint(constrProbl.getVarByName(first),constrProbl.getVarByName(second)));
			}
			else if(op=='>'&& !spec)
			{
				second=lexer.getString();
				constrProbl.addConstraint(new GreaterConstraint(constrProbl.getVarByName(first),constrProbl.getVarByName(second)));
			}
			else if(op=='>'&& spec)
			{
				second=lexer.getString();
				constrProbl.addConstraint(new GreaterEqualConstraint(constrProbl.getVarByName(first),constrProbl.getVarByName(second)));
			}
			else if(op=='<'&& !spec)
			{
				second=lexer.getString();
				constrProbl.addConstraint(new GreaterConstraint(constrProbl.getVarByName(second),constrProbl.getVarByName(first)));
			}
			else if(op=='<'&& spec)
			{
				second=lexer.getString();
				constrProbl.addConstraint(new GreaterEqualConstraint(constrProbl.getVarByName(second),constrProbl.getVarByName(first)));
			}
			else throw new ParserException("expected != or = or < or < or >= or <=");
			
			try
			{
				first=lexer.getString();
				if(first.equals(Symbols.EXTERNAL))
				{
					current=first;
					return constrProbl;
				}
			}
			catch(LexerException e)
			{
				return constrProbl;		
			}
			
		}

	}
	/**Controlla la sintassi di un dominio
     * 
     * @return Domain
     *
     */

	public Domain parseDomain() throws ParserException, LexerException
	{
		Domain dom=new Domain();
		
		char c = lexer.getChar();
		
		if(c!=Symbols.APERTA_QUADRA) throw new ParserException("expected "+Symbols.APERTA_QUADRA+" found "+c);
				
		while(true)
		{	
			int min=lexer.getInt();
			
			c=lexer.getChar();
			
			if(c==Symbols.VIRGOLA)
			{
				dom.addValue(min);
				continue;
			}
			else if(c==Symbols.PUNTO)
			{
				c=lexer.getChar(); //consuma l'altro punto
				int max=lexer.getInt();
				dom.addInterval(min,max);
				c=lexer.getChar();
					if(c==Symbols.VIRGOLA)
					{
						continue;
					}					
					else if(c==Symbols.CHIUSA_QUADRA)
					{
						break;
					}
			}
					
			else if(c==Symbols.CHIUSA_QUADRA)
			{
				dom.addValue(min);
				break;
			}
			else throw new ParserException("expected "+Symbols.VIRGOLA+" or "+Symbols.PUNTOPRINT+" or "+Symbols.VIRGOLA+" or "+Symbols.CHIUSA_QUADRA+"found "+c);
		}
		return dom;
	}

	/**Controlla la sintassi di un distributed constraint problem
     * 
     * @return DisConstraintProblem
     *
     */
	
	public DisConstraintProblem parseDisConstraintProblem() throws 	ParserException,
																LexerException,
																ExistentVarException,
																UnknownVariableException,
																NotBinaryConstrException
	{
		ConstraintProblem localCP= parseConstraintProblem();
		DisConstraintProblem distrCP= new DisConstraintProblem(localCP);
		
		String txt; //External
		
		if(! current.equals(Symbols.EXTERNAL))
		{
			throw new ParserException("not found the expected keyword "+Symbols.EXTERNAL);
			//return distrCP;	
		}

		txt=lexer.getString(); //Constraints
		if(! txt.equals(Symbols.CONSTRAINTS)) throw new ParserException("not found the expected keyword "+Symbols.CONSTRAINTS);
		//separ
		String first=lexer.getString();
		String second;
		char op;
		boolean spec;
		while(first!=null)
		{
			spec=false;
			op=lexer.getChar();
			if(op==Symbols.SPECIAL)
			{
				op=lexer.getChar();
				spec=true;
			}
			
			
			if(op=='='&& !spec)
			{
				second=lexer.getString();
				distrCP.addExternalConstraint(new ExtEqualConstraint(localCP.getVarByName(first),second));
			}
			else if(op=='='&& spec)
			{
				second=lexer.getString();
				distrCP.addExternalConstraint(new ExtNotEqualConstraint(localCP.getVarByName(first),second));
			}
			else if(op=='>'&& !spec)
			{
				second=lexer.getString();
				distrCP.addExternalConstraint(new ExtGreaterConstraint(localCP.getVarByName(first),second));
			}
			else if(op=='>'&& spec)
			{
				second=lexer.getString();
				distrCP.addExternalConstraint(new ExtGreaterEqualConstraint(localCP.getVarByName(first),second));
			}
			else if(op=='<'&& !spec)
			{
				second=lexer.getString();
				distrCP.addExternalConstraint(new ExtLessConstraint(localCP.getVarByName(first),second));
			}
			else if(op=='<'&& spec)
			{
				second=lexer.getString();
				distrCP.addExternalConstraint(new ExtLessEqualConstraint(localCP.getVarByName(first),second));
			}
			else throw new ParserException("expected != or = or < or < or >= or <=");
			
			try
			{
				first=lexer.getString();
			}
			catch(LexerException e)
			{
				return distrCP;		
			}
			
		}

		return distrCP;		
	}

}